<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package yourweblayout
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<link href='https://fonts.googleapis.com/css?family=EB+Garamond' rel='stylesheet' type='text/css'>
<link href='https://fonts.googleapis.com/css?family=Roboto:400,400italic,500,500italic,700,300,300italic' rel='stylesheet' type='text/css'>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'yourweblayout' ); ?></a>

	<header id="masthead" class="site-header">
		<div class="container">

			<div class="row">
				<div class="col-sm-4 logo">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('header-1') ) : endif; ?></a>
				</div><!-- .col -->
				<div class=" col-sm-8">
				<div class="header-contact">
				<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('header-2') ) : endif; ?>
				</div><!--.header-contact-->
				<nav id="site-navigation" class="navbar navbar-default">
					<div class="navbar-header">
                    	<!--<a class="navbar-brand visible-xs" href="#">Main Menu</a>-->
						<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#primary-navbar">
							<span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
					</div><!-- .navbar-header -->

					<?php wp_nav_menu( array(
						'menu'              => 'primary',
						'theme_location'    => 'primary',
						'depth'             => 3,
						'container'         => 'div',
						'container_class'   => 'collapse navbar-collapse alignright',
						'container_id'      => 'primary-navbar',
						'menu_class'        => 'nav navbar-nav',
						'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
						'walker'            => new wp_bootstrap_navwalker())
						);
					?>
				</nav><!-- #site-navigation -->
				</div><!-- .col -->
			</div><!-- .row -->
		</div><!-- .container -->
	</header><!-- .site-header -->
	
	  <head>
    <!-- Your Version 4 js file gets repalced with the .js files for the styles you want to use -->
    <!-- In this example, we added the Solid and Brands styles, but you can add any or all of the styles -->
    <script defer src="/dev/wp-content/themes/yourweblayout/js/solid.js"></script>
    <script defer src="/dev/wp-content/themes/yourweblayout/js/brands.js"></script>

    <!-- add the core fontawesome.js file -->
    <script defer src="/dev/wp-content/themes/yourweblayout/js/fontawesome.js"></script>

    <!-- support v4 icon references/syntax for SVG+JS -->
    <script defer src="/dev/wp-content/themes/yourweblayout/js/v4-shims.js"></script>    
  </head>
  <body>
    <!-- Your icons should show up just as before -->
  </body>
	

	<div id="content" class="site-content">
		<div class="container">
